/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.model.CableModelBase;
import org.cyclops.integrateddynamics.client.model.IRenderState;

public class CableModel
extends CableModelBase {
    public CableModel(BlockState state, Direction facing, Random rand, IModelData modelData) {
        super(state, facing, rand, modelData);
    }

    public CableModel(ItemStack itemStack, Level world, LivingEntity entity) {
        super(itemStack, world, entity);
    }

    public CableModel() {
    }

    @Override
    protected boolean isRealCable(IModelData modelData) {
        return (Boolean)ModelHelpers.getSafeProperty((IModelData)modelData, BlockCable.REALCABLE, (Object)true);
    }

    @Override
    protected Optional<BlockState> getFacade(IModelData modelData) {
        return (Optional)ModelHelpers.getSafeProperty((IModelData)modelData, BlockCable.FACADE, Optional.empty());
    }

    @Override
    protected boolean isConnected(IModelData modelData, Direction side) {
        return (Boolean)ModelHelpers.getSafeProperty((IModelData)modelData, BlockCable.CONNECTED[side.ordinal()], (Object)false);
    }

    @Override
    protected boolean hasPart(IModelData modelData, Direction side) {
        return this.getPartRenderPosition(modelData, side) != PartRenderPosition.NONE;
    }

    @Override
    protected PartRenderPosition getPartRenderPosition(IModelData modelData, Direction side) {
        return (PartRenderPosition)ModelHelpers.getSafeProperty((IModelData)modelData, BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)PartRenderPosition.NONE);
    }

    @Override
    protected boolean shouldRenderParts(IModelData modelData) {
        return ModelHelpers.getSafeProperty((IModelData)modelData, BlockCable.PARTCONTAINER, null) != null;
    }

    @Override
    protected BakedModel getPartModel(IModelData modelData, Direction side) {
        IPartContainer partContainer = (IPartContainer)ModelHelpers.getSafeProperty((IModelData)modelData, BlockCable.PARTCONTAINER, null);
        BlockState blockState = partContainer != null && partContainer.hasPart(side) ? partContainer.getPart(side).getBlockState(partContainer, side) : null;
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = mc.m_91289_();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.m_110907_();
        return blockModelShapes.m_110893_(blockState);
    }

    @Override
    protected IRenderState getRenderState(IModelData modelData) {
        return (IRenderState)ModelHelpers.getSafeProperty((IModelData)modelData, BlockCable.RENDERSTATE, null);
    }

    public BakedModel handleBlockState(BlockState state, Direction side, Random rand, IModelData modelData) {
        return new CableModel(state, side, rand, modelData);
    }

    public BakedModel handleItemState(ItemStack stack, Level world, LivingEntity entity) {
        return new CableModel(stack, world, entity);
    }
}

